BalanceBarStamp = function(canvas, rect, max, leftValue, rightValue, leftPaint, rightPaint)
    local adjust = canvas:metrics():growthAdjustment()
    leftValue = math.max(tonumber(leftValue) or 0, 0)
    rightValue = math.max(tonumber(rightValue) or 0, 0)
    local midx = rect:midx()
    local maxLength = rect:width() / 2 - 1 * adjust
    local leftRect = rect:copy()
    leftRect.left = midx - 1 * adjust - (leftValue / max) * maxLength
    leftRect.right = midx - 1 * adjust
    canvas:setPaint(leftPaint):fill(Path.rect(leftRect))
    local rightRect = rect:copy()
    rightRect.left = midx + 1 * adjust
    rightRect.right = midx + 1 * adjust + (rightValue / max) * maxLength
    canvas:setPaint(rightPaint):fill(Path.rect(rightRect))
end

return BalanceBarStamp
